/******************************************************************
/* [COMIDAS sample program by COMIZOA Inc., Ltd]
/*
/* - Subject : Pulse Generator
/* - Contents:  α׷ ڰ ϴ ļ  ޽ 
/*			ڰ ߴ  Ͽ ߻ϴ α׷Դϴ.
/* - Remarks :
/*	   1.   COMI-SD501 忡 밡մϴ.
/******************************************************************/
#include <windows.h>
#include <stdio.h>
#include <conio.h>
#include "comidas.h"

#define FREQ	1000.f /* Pulse freq. = 1 kHz */
#define PG_CH	0  /* Pulse Generator Channel number */

void main()
{
	HANDLE hDevice;
	double ActFreq;

	COMI_LoadDll();
	hDevice = COMI_LoadDevice (COMI_SD501, 0); /* Load device */

	printf("Generating infinite number of pulses through CH%d\n", PG_CH);
	printf("Set Freq.(Hz)    = %.0f\n", FREQ);
	/* Start pulse generation */
	ActFreq = COMI_PG_Start(hDevice, PG_CH, FREQ, 0);
	printf("Actual Freq.(Hz) = %.0f\n", ActFreq);
	printf("Press any key to exit !\n");
	while(!kbhit())
		;
	COMI_PG_Stop (hDevice, PG_CH); /* Stop pulse generation */
	COMI_UnloadDevice(hDevice);
	COMI_UnloadDll();
}